' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Partial Class Status
  Inherits System.Web.UI.Page

  Protected Sub GridView1_RowUpdated(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.GridViewUpdatedEventArgs) Handles GridView1.RowUpdated
    ' Sprawd, czy wystpi bd
    If e.Exception Is Nothing Then
      ' Nastpnie zobacz ile wierszy zostao zaktualizowanych. 1 oznacza powodzenie, 0 lub -1 znaczy, e opis ju istnia
      If e.AffectedRows <> 1 Then
        lblStatus.Text = "Status o tej nazwie ju istnieje. Prosz wybra inn nazw."
        e.KeepInEditMode = True
      End If
    Else
      lblStatus.Text = "Podczas aktualizacji statusu wystpi bd. Szczegy wyjtku: " + e.Exception.Message
    End If
  End Sub

  Protected Sub lnkCreateNew_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles lnkCreateNew.Click
    FormView1.ChangeMode(FormViewMode.Insert)
    SwitchVisibilityMode(True)
  End Sub

  Protected Sub FormView1_ItemInserted(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.FormViewInsertedEventArgs) Handles FormView1.ItemInserted
    If e.Exception Is Nothing Then
      If Not (e.AffectedRows = 1) Then
        lblStatus.Text = "Status o tej nazwie ju istnieje. Prosz wybra inn nazw."
        e.KeepInInsertMode = True
      Else
        SwitchVisibilityMode(False)
        GridView1.DataBind()
      End If
    Else
      lblStatus.Text = "Podczas aktualizacji statusu wystpi bd. Szczegy wyjtku: " + e.Exception.Message
    End If
  End Sub

  Private Sub SwitchVisibilityMode(ByVal isInserting As Boolean)
    FormView1.Visible = isInserting
    GridView1.Visible = Not isInserting
    lnkCreateNew.Visible = Not isInserting
  End Sub

  Protected Sub FormView1_ItemCommand(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.FormViewCommandEventArgs) Handles FormView1.ItemCommand
    Select Case e.CommandName.ToUpper()
      Case "CANCEL"
        SwitchVisibilityMode(False)
    End Select
  End Sub

  Protected Sub GridView1_DataBound(ByVal sender As Object, ByVal e As System.EventArgs) Handles GridView1.DataBound
    ' Sformatuj nasz pasek z odnonikami do stron
    If GridView1.TopPagerRow IsNot Nothing Then
      Helpers.FormatGridViewPagerBar(GridView1.TopPagerRow)
    End If
    If GridView1.BottomPagerRow IsNot Nothing Then
      Helpers.FormatGridViewPagerBar(GridView1.BottomPagerRow)
    End If
  End Sub
End Class
